#ifdef __DCL_INTERNAL__

#if defined(__COMPILE_ListedStringToStringMap__)
	#define THIS_NAME						__szListedStringToStringMap_h__
	#define THIS_VALUE						__T("dcl/__LISTED_HASHMAP.h/ListedStringToStringMap")
	#define LISTED_HASHMAP_T				ListedStringToStringMap
	#define HASHFUN_T						HashFun<String>
	#define KEY_T							String
	#define VALUE_T							String
	#define VALUE_T_CAST
	#define HAVE_CONSTRUCTOR_KEY			1
	#define HAVE_CONSTRUCTOR_VALUE			1
#elif defined(__COMPILE_ListedStringToPointerMap__)
	#define THIS_NAME						__szListedStringToPointerMap_h__
	#define THIS_VALUE						__T("dcl/__LISTED_HASHMAP.h/ListedStringToPointerMap")
	#define LISTED_HASHMAP_T				ListedStringToPointerMap
	#define HASHFUN_T						HashFun<String>
	#define KEY_T							String
	#define VALUE_T							void*
	#define VALUE_T_CAST					(void*)
	#define HAVE_CONSTRUCTOR_KEY			1
	#define HAVE_CONSTRUCTOR_VALUE			0
#elif defined(__COMPILE_ListedStringToStringArrayMap__)
	#define THIS_NAME						__szListedStringToStringArrayMap_h__
	#define THIS_VALUE						__T("dcl/__LISTED_HASHMAP.h/ListedStringToStringArrayMap")
	#define LISTED_HASHMAP_T				ListedStringToStringArrayMap
	#define HASHFUN_T						HashFun<String>
	#define KEY_T							String
	#define VALUE_T							StringArray
	#define VALUE_T_CAST	
	#define HAVE_CONSTRUCTOR_KEY			1
	#define HAVE_CONSTRUCTOR_VALUE			1
#elif defined(__COMPILE_ListedByteStringToByteStringMap__)
	#define THIS_NAME						__szListedByteStringToByteStringMap_h__
	#define THIS_VALUE						__T("dcl/__LISTED_HASHMAP.h/ListedByteStringToByteStringMap")
	#define LISTED_HASHMAP_T				ListedByteStringToByteStringMap
	#define HASHFUN_T						HashFun<ByteString>
	#define KEY_T							ByteString
	#define VALUE_T							ByteString
	#define VALUE_T_CAST
	#define HAVE_CONSTRUCTOR_KEY			1
	#define HAVE_CONSTRUCTOR_VALUE			1
#endif

#if __DCL_HAVE_THIS_FILE__
	static const char_t THIS_NAME[] = THIS_VALUE;
	#undef __THIS_FILE__
	#define __THIS_FILE__ THIS_NAME
#endif

/**
 * template class HASHMAP_T의 DSO 호환성을 제공한다.
 * <p>C++의 template class는 해당 코드를 사용하기 전에는 실제 이진 코드를 생성하지 않으므로,
 * DSO(so, DLL)와 DSO, 또는 실행파일에서 객체를 주고받을 수 없다.<p>
 * <p>이 클래스는 DSO의 이러한 문제를 해결하며,
 * 포함파일은 <code>&lt;dcl/ListedHashMap.h&gt;</code>이다.</p>
 * <p>이 코드를 사용하는 클래스는 다음과 같다.</p>
 * <ul>
 *      <li>class DCLCAPI ListedStringToStringMap</li>
 *      <li>class DCLCAPI ListedStringToPointerMap</li>
 * </ul>
 *
 * @see LISTED_HASHMAP_T
 */
class DCLCAPI LISTED_HASHMAP_T : public Object
{
	DECLARE_CLASSINFO(LISTED_HASHMAP_T)
public:
	virtual String toString() const;

public:
	struct Assoc
	{
		KEY_T			key;
		VALUE_T		value;

		Assoc() {}
		Assoc(const KEY_T& _key, const VALUE_T& _value)
		{
			this->key = _key;
			this->value = VALUE_T_CAST _value;
		}
	};

	/**
	 * @see {@link LISTED_HASHMAP_T#put(constKEY&,constVALUE&,UpdateCallback&) LISTED_HASHMAP_T::put}
	 */
	class UpdateCallback
	{
	protected:
		virtual void onUpdate(const Assoc& _assoc) = 0;
		friend class LISTED_HASHMAP_T;
	};

	struct HashNode : public Assoc, public NodeBase
	{
		HashNode* pNext;
	};

	class ConstIterator;
	class Iterator : public ListIteratorBase
	{
	public:
		Iterator();
		Iterator(NodeBase* _pNode);
		Iterator(const Iterator& _it);
		Iterator& operator=(const Iterator& _it);
		Iterator& operator++();
		Iterator operator++(int);
		Iterator& operator--();
		Iterator operator--(int);
		Assoc& operator*();

	protected:
		friend class ConstIterator;
	};

	class ConstIterator : public ConstListIteratorBase
	{
	public:
		ConstIterator();
		ConstIterator(const NodeBase* _pNode);
		ConstIterator(const ConstIterator& _it);
		ConstIterator(const Iterator& _it);
		ConstIterator& operator=(const ConstIterator& _it);
		ConstIterator& operator++();
		ConstIterator operator++(int);
		ConstIterator& operator--();
		ConstIterator operator--(int);
		const Assoc& operator*();
	};

	class ReverseConstIterator;
	class ReverseIterator : public ListIteratorBase
	{
	public:
		ReverseIterator();
		ReverseIterator(NodeBase* _pNode);
		ReverseIterator(const ReverseIterator& _it);
		ReverseIterator& operator=(const ReverseIterator& _it);
		ReverseIterator& operator++();
		ReverseIterator operator++(int);
		ReverseIterator& operator--();
		ReverseIterator operator--(int);
		Assoc& operator*();

	protected:
		friend class ReverseConstIterator;
	};

	class ReverseConstIterator : public ConstListIteratorBase
	{
	public:
		ReverseConstIterator();
		ReverseConstIterator(const NodeBase* _pNode);
		ReverseConstIterator(const ReverseConstIterator& _it);
		ReverseConstIterator(const ReverseIterator& _it);
		ReverseConstIterator& operator=(const ReverseConstIterator& _it);
		ReverseConstIterator& operator++();
		ReverseConstIterator operator++(int);
		ReverseConstIterator& operator--();
		ReverseConstIterator operator--(int);
		const Assoc& operator*();
	};

public:
	virtual ~LISTED_HASHMAP_T();
	void initBuckets(size_t _bucketSize);
	LISTED_HASHMAP_T(size_t _bucketSize = 21);

	LISTED_HASHMAP_T(const LISTED_HASHMAP_T& _src);
	const LISTED_HASHMAP_T& operator=(const LISTED_HASHMAP_T& _src);

	ConstIterator begin() const;
	ConstIterator end() const;
	Iterator begin();
	Iterator end();

	ReverseConstIterator rbegin() const;
	ReverseConstIterator rend() const;
	ReverseIterator rbegin();
	ReverseIterator rend();

	size_t bucketSize() const;
	size_t size() const;
	size_t sizeOfBucket(size_t index) const;
	bool isEmpty() const;
	Iterator find(const KEY_T& _key);
	ConstIterator find(const KEY_T& _key) const;
	bool lookup(const KEY_T& _key, VALUE_T& _rValue) const;
	VALUE_T& operator[](const KEY_T&  _key);

	/**
	 * _key와 동일한 노드가 있으면 _value를 변경하기 전에 _cb를 호출한다.
	 */
	void put(const KEY_T& _key, const VALUE_T& _value, UpdateCallback& _cb);

	size_t erase(const KEY_T& _key);
	size_t erase(const Iterator& _it);
	void clear();

protected:
	size_t bucketIndex(const KEY_T& _key) const;
	HashNode* createNode(const KEY_T& _key);
	void destroyNode(HashNode* _pNode);

protected:
	NodeBase*		__pMasterNode;
	HASHFUN_T		__hashFun;
	size_t				__size;			// count of all elements
	PointerArray		__buckets;
};

////////////// Inline LISTED_HASHMAP_T::Iterator ////////////////////

inline
LISTED_HASHMAP_T::Iterator::Iterator()
{
	__pNode = NULL;
}

inline
LISTED_HASHMAP_T::Iterator::Iterator(NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LISTED_HASHMAP_T::Iterator::Iterator(const Iterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LISTED_HASHMAP_T::Iterator&
LISTED_HASHMAP_T::Iterator::operator=(const Iterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LISTED_HASHMAP_T::Iterator&
LISTED_HASHMAP_T::Iterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LISTED_HASHMAP_T::Iterator
LISTED_HASHMAP_T::Iterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return Iterator(pSaveNode);
}

inline
LISTED_HASHMAP_T::Iterator&
LISTED_HASHMAP_T::Iterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LISTED_HASHMAP_T::Iterator
LISTED_HASHMAP_T::Iterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return Iterator(pSaveNode);
}

inline
LISTED_HASHMAP_T::Assoc&
LISTED_HASHMAP_T::Iterator::operator*()
{
	__DCL_ASSERT(__pNode != NULL);
	return *(HashNode*) __pNode;
}

////////////// Inline LISTED_HASHMAP_T::ConstIterator ////////////////////

inline
LISTED_HASHMAP_T::ConstIterator::ConstIterator()
{
	__pNode = NULL;
}

inline
LISTED_HASHMAP_T::ConstIterator::ConstIterator(const NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LISTED_HASHMAP_T::ConstIterator::ConstIterator(const ConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LISTED_HASHMAP_T::ConstIterator::ConstIterator(const Iterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LISTED_HASHMAP_T::ConstIterator&
LISTED_HASHMAP_T::ConstIterator::operator=(const ConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LISTED_HASHMAP_T::ConstIterator&
LISTED_HASHMAP_T::ConstIterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LISTED_HASHMAP_T::ConstIterator
LISTED_HASHMAP_T::ConstIterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return ConstIterator(pSaveNode);
}

inline
LISTED_HASHMAP_T::ConstIterator&
LISTED_HASHMAP_T::ConstIterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LISTED_HASHMAP_T::ConstIterator
LISTED_HASHMAP_T::ConstIterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return ConstIterator(pSaveNode);
}

inline
const LISTED_HASHMAP_T::Assoc&
LISTED_HASHMAP_T::ConstIterator::operator*()
{
	__DCL_ASSERT(__pNode != NULL);
	return *(HashNode*) __pNode;
}

////////////// Inline LISTED_HASHMAP_T::ReverseIterator ////////////////////

inline
LISTED_HASHMAP_T::ReverseIterator::ReverseIterator()
{
	__pNode = NULL;
}

inline
LISTED_HASHMAP_T::ReverseIterator::ReverseIterator(NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LISTED_HASHMAP_T::ReverseIterator::ReverseIterator(const ReverseIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LISTED_HASHMAP_T::ReverseIterator&
LISTED_HASHMAP_T::ReverseIterator::operator=(const ReverseIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LISTED_HASHMAP_T::ReverseIterator&
LISTED_HASHMAP_T::ReverseIterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LISTED_HASHMAP_T::ReverseIterator
LISTED_HASHMAP_T::ReverseIterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return ReverseIterator(pSaveNode);
}

inline
LISTED_HASHMAP_T::ReverseIterator&
LISTED_HASHMAP_T::ReverseIterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LISTED_HASHMAP_T::ReverseIterator
LISTED_HASHMAP_T::ReverseIterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return ReverseIterator(pSaveNode);
}

inline
LISTED_HASHMAP_T::Assoc&
LISTED_HASHMAP_T::ReverseIterator::operator*()
{
	__DCL_ASSERT(__pNode != NULL);
	return *(HashNode*) __pNode;
}

////////////// Inline LISTED_HASHMAP_T::Iterator ////////////////////

inline
LISTED_HASHMAP_T::ReverseConstIterator::ReverseConstIterator()
{
	__pNode = NULL;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator::ReverseConstIterator(const NodeBase* _pNode)
{
	__DCL_ASSERT(_pNode != NULL);
	__pNode = _pNode;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator::ReverseConstIterator(const ReverseConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator::ReverseConstIterator(const ReverseIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator&
LISTED_HASHMAP_T::ReverseConstIterator::operator=(const ReverseConstIterator& _it)
{
	__DCL_ASSERT(_it.__pNode != NULL);
	__pNode = _it.__pNode;
	return *this;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator&
LISTED_HASHMAP_T::ReverseConstIterator::operator++()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pPrev;
	return *this;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator
LISTED_HASHMAP_T::ReverseConstIterator::operator++(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pPrev;
	return ReverseConstIterator(pSaveNode);
}

inline
LISTED_HASHMAP_T::ReverseConstIterator&
LISTED_HASHMAP_T::ReverseConstIterator::operator--()
{
	__DCL_ASSERT(__pNode != NULL);
	__pNode = __pNode->pNext;
	return *this;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator
LISTED_HASHMAP_T::ReverseConstIterator::operator--(int)
{
	__DCL_ASSERT(__pNode != NULL);
	const NodeBase* pSaveNode = __pNode;
	__pNode = __pNode->pNext;
	return ReverseConstIterator(pSaveNode);
}

inline
const LISTED_HASHMAP_T::Assoc&
LISTED_HASHMAP_T::ReverseConstIterator::operator*()
{
	__DCL_ASSERT(__pNode != NULL);
	return *(HashNode*) __pNode;
}

////////////// Inline List Part of LISTED_HASHMAP_T ////////////////////

inline
LISTED_HASHMAP_T::ConstIterator
LISTED_HASHMAP_T::begin() const
{
	return __pMasterNode->pNext;
}

inline
LISTED_HASHMAP_T::ConstIterator
LISTED_HASHMAP_T::end() const
{
	return __pMasterNode;
}

inline
LISTED_HASHMAP_T::Iterator
LISTED_HASHMAP_T::begin()
{
	return __pMasterNode->pNext;
}

inline
LISTED_HASHMAP_T::Iterator
LISTED_HASHMAP_T::end()
{
	return __pMasterNode;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator
LISTED_HASHMAP_T::rbegin() const
{
	return __pMasterNode->pPrev;
}

inline
LISTED_HASHMAP_T::ReverseConstIterator
LISTED_HASHMAP_T::rend() const
{
	return __pMasterNode;
}

inline
LISTED_HASHMAP_T::ReverseIterator
LISTED_HASHMAP_T::rbegin()
{
	return __pMasterNode->pPrev;
}

inline
LISTED_HASHMAP_T::ReverseIterator
LISTED_HASHMAP_T::rend()
{
	return __pMasterNode;
}

////////////// Inline HashMap Part of LISTED_HASHMAP_T  ////////////////////

inline
size_t
LISTED_HASHMAP_T::bucketSize() const
{
	return __buckets.size();
}

inline
size_t
LISTED_HASHMAP_T::size() const
{
	return __size;
}

inline
bool
LISTED_HASHMAP_T::isEmpty() const
{
	return __size == 0;
}

#if __DCL_HAVE_THIS_FILE__
	#undef __THIS_FILE__
	#define __THIS_FILE__	__T(__FILE__)
#endif

#undef THIS_NAME
#undef THIS_VALUE
#undef LISTED_HASHMAP_T
#undef HASHFUN_T
#undef KEY_T
#undef VALUE_T
#undef VALUE_T_CAST
#undef HAVE_CONSTRUCTOR_KEY
#undef HAVE_CONSTRUCTOR_VALUE

#endif			// __DCL_INTERNAL__
