
/*
Visual C++ 의 경우 템클레이트 클래스의 맴버 클래스의 맴버들에 
대하여 코드를 생성하지 못하는 버그가 있다.

BUG: LNK2001 on Member Function When Use Nested Class Template
Last reviewed: July 24, 1997
Article ID: Q128789  
The information in this article applies to: 
The Microsoft C/C++ Compiler (CL.EXE) included with:
	- Microsoft Visual C++, 32-bit Edition, versions 2.0, 2.1, 4.0, 4.1, 4.2, 5.0
*/

#ifndef __DCL_LIST_T_H__
#error "Never include <dcl/__ListT-GCC.h> directly; use <dcl/ListT.h> instead."
#endif

__DCL_BEGIN_NAMESPACE

#if __DCL_HAVE_THIS_FILE__
	static const char_t __szListT_h__[] = __T("dcl/__ListT-MSC.h");
	#undef __THIS_FILE__
	#define __THIS_FILE__ __szListT_h__
#endif

template<typename ELEMENT>
class List : public Object
{
	DECLARE_CLASSINFO(List)
public:
	struct ListNode : public NodeBase
	{
		ELEMENT	data;
	};
	
	class ConstIterator;
	class Iterator : public ListIteratorBase
	{
	public:
		Iterator()
		{
			__pNode = NULL;
		}

		Iterator(NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		Iterator(const Iterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		Iterator& operator=(const Iterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		Iterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		Iterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return Iterator(pSaveNode);
		}

		Iterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		Iterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return Iterator(pSaveNode);
		}

		ELEMENT& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return ((ListNode*)__pNode)->data;
		}

	protected:
		friend typename List<ELEMENT>;
		friend class ConstIterator;
	};

	class ConstIterator : public ConstListIteratorBase
	{
	public:
		ConstIterator()
		{
			__pNode = NULL;
		}

		ConstIterator(const NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		ConstIterator(const ConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ConstIterator(const Iterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ConstIterator& operator=(const ConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		ConstIterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		ConstIterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return ConstIterator(pSaveNode);
		}

		ConstIterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		ConstIterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return ConstIterator(pSaveNode);
		}

		const ELEMENT& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return ((ListNode*)__pNode)->data;
		}
	};

	class ReverseConstIterator;
	class ReverseIterator : public ListIteratorBase
	{
	public:
		ReverseIterator()
		{
			__pNode = NULL;
		}

		ReverseIterator(NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		ReverseIterator(const ReverseIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ReverseIterator& operator=(const ReverseIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		ReverseIterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		ReverseIterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return ReverseIterator(pSaveNode);
		}

		ReverseIterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		ReverseIterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return ReverseIterator(pSaveNode);
		}

		ELEMENT& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return ((ListNode*)__pNode)->data;
		}

	protected:
		friend typename List<ELEMENT>;
		friend class ReverseConstIterator;
	};

	class ReverseConstIterator : public ConstListIteratorBase
	{
	public:
		ReverseConstIterator()
		{
			__pNode = NULL;
		}

		ReverseConstIterator(const NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		ReverseConstIterator(const ReverseConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ReverseConstIterator(const ReverseIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ReverseConstIterator& operator=(const ReverseConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		ReverseConstIterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		ReverseConstIterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return ReverseConstIterator(pSaveNode);
		}

		ReverseConstIterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		ReverseConstIterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return ReverseConstIterator(pSaveNode);
		}

		const ELEMENT& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return ((ListNode*)__pNode)->data;
		}
	};

public:
	virtual ~List();
	List();
	List(const List<ELEMENT>& _src);
	const List<ELEMENT>& operator=(const List<ELEMENT>& _src);

	ConstIterator begin() const;
	ConstIterator end() const;
	Iterator begin();
	Iterator end();

	ReverseConstIterator rbegin() const;
	ReverseConstIterator rend() const;
	ReverseIterator rbegin();
	ReverseIterator rend();

	// return is inserted element Iterator
	Iterator insert(Iterator _pos, const ELEMENT& _element);
	void insert(Iterator _pos, ConstIterator _first, ConstIterator _last);
	
	// return is next Iterator	
	Iterator erase(Iterator _pos);
	void splice(Iterator _pos,
		List<ELEMENT>& _other, Iterator _otherFirst, Iterator _otherLast);
	
	List<ELEMENT>& addHead(const ELEMENT& _element);
	List<ELEMENT>& addTail(const ELEMENT& _element);
	List<ELEMENT>& add(const ELEMENT& _element);

	ELEMENT removeHead();
	ELEMENT removeTail();

	void clear();
	bool isEmpty() const;
	size_t size() const;

protected:
	NodeBase*	__pMasterNode;
	size_t			__size;

	size_t  size(ConstIterator _first, ConstIterator _last) const;
	// _first ~ _last to posTo
	void move(Iterator posTo, Iterator _first, Iterator _last);

	ListNode* createNode(const ELEMENT& _element);
	void destroyNode(ListNode* _pNode);
};

////////////// Inline List ////////////////////

template<typename ELEMENT>
inline
typename List<ELEMENT>::ConstIterator
List<ELEMENT>::begin() const
{
	return __pMasterNode->pNext;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::ConstIterator
List<ELEMENT>::end() const
{
	return __pMasterNode;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::Iterator
List<ELEMENT>::begin()
{
	return __pMasterNode->pNext;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::Iterator
List<ELEMENT>::end()
{
	return __pMasterNode;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::ReverseConstIterator
List<ELEMENT>::rbegin() const
{
	return __pMasterNode->pPrev;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::ReverseConstIterator
List<ELEMENT>::rend() const
{
	return __pMasterNode;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::ReverseIterator
List<ELEMENT>::rbegin()
{
	return __pMasterNode->pPrev;
}

template<typename ELEMENT>
inline
typename List<ELEMENT>::ReverseIterator
List<ELEMENT>::rend()
{
	return __pMasterNode;
}

template<typename ELEMENT>
inline
bool
List<ELEMENT>::isEmpty() const
{
	return __pMasterNode->pNext == __pMasterNode;
}

template<typename ELEMENT>
inline
size_t
List<ELEMENT>::size() const
{
	return __size;
}


template<typename ELEMENT>
inline
List<ELEMENT>&
List<ELEMENT>::addHead(const ELEMENT& _element)
{
	insert(begin(), _element);
	return *this;
}

template<typename ELEMENT>
inline
List<ELEMENT>&
List<ELEMENT>::addTail(const ELEMENT& _element)
{
	insert(end(), _element);
	return *this;
}

template<typename ELEMENT>
inline
List<ELEMENT>&
List<ELEMENT>::add(const ELEMENT& _element)
{
	insert(end(), _element);
	return *this;
}
////////// Implement List ///////////////////

// IMPLEMENT_CLASSINFO(List<ELEMENT>, Object)
#ifdef __DCL_NO_RTTI
template<typename ELEMENT>
const Object::ClassInfo List<ELEMENT>::m_classInfo =
{
	__DCL_NAMESPACE_STRING __S(List),
	sizeof(class List),
	&Object::m_classInfo
};

template<typename ELEMENT>
const Object::ClassInfo* List<ELEMENT>::classInfo() const
{
	return CLASSINFO(class_name);
}
#else
template<typename ELEMENT>
const std::type_info& List<ELEMENT>::typeInfo() const
{
	return typeid(List);
}
#endif

template<typename ELEMENT>
List<ELEMENT>::~List()
{
	if (!isEmpty())
		clear();
	free(__pMasterNode);
}

template<typename ELEMENT>
List<ELEMENT>::List()
{
	__pMasterNode = (NodeBase*) malloc(sizeof(NodeBase));
	// FIXME!
	// if (pNode == NULL)
	//		throw new BadAllocException(sizeof(HashNode), __THIS_FILE__, __LINE__);
	__DCL_ASSERT(__pMasterNode != NULL);

	__pMasterNode->pPrev = __pMasterNode;
	__pMasterNode->pNext = __pMasterNode;
	__size = 0;
}

template<typename ELEMENT>
List<ELEMENT>::List(const List<ELEMENT>& _src)
{
	__pMasterNode = (NodeBase*) malloc(sizeof(NodeBase));
	// FIXME!
	// if (pNode == NULL)
	//		throw new BadAllocException(sizeof(HashNode), __THIS_FILE__, __LINE__);
	__DCL_ASSERT(__pMasterNode != NULL);

	__pMasterNode->pPrev = __pMasterNode;
	__pMasterNode->pNext = __pMasterNode;
	__size = 0;

	insert(end(), _src.begin(), _src.end());
}

template<typename ELEMENT>
const
List<ELEMENT>&
List<ELEMENT>::operator=(const List<ELEMENT>& _src)
{
	if (&_src != this)
	{
		if (!isEmpty())
			clear();
		insert(end(), _src.begin(), _src.end());
	}
	return *this;
}

template<typename ELEMENT>
typename List<ELEMENT>::ListNode*
List<ELEMENT>::createNode(const ELEMENT& _element)
{
	ListNode* pNode = (ListNode*) malloc(sizeof(ListNode));
	// FIXME!
	// if (pNode == NULL)
	//		throw new BadAllocException(sizeof(HashNode), __THIS_FILE__, __LINE__);

#if __DCL_HAVE_ALLOC_DEBUG
#undef new
#endif

	new(&(pNode->data)) ELEMENT;

#if __DCL_HAVE_ALLOC_DEBUG
#define new __DCL_DEBUG_NEW
#endif

	pNode->data = _element;
	return pNode;
}

template<typename ELEMENT>
void
List<ELEMENT>::destroyNode(ListNode* _pNode)
{
	_pNode->data.~ELEMENT();
	free(_pNode);
}

template<typename ELEMENT>
typename List<ELEMENT>::Iterator
List<ELEMENT>::insert(Iterator _pos, const ELEMENT& _element)
{
	ListNode* pNewNode = createNode(_element);
	pNewNode->pPrev = _pos.__pNode->pPrev;
	pNewNode->pNext = _pos.__pNode;
	_pos.__pNode->pPrev->pNext = pNewNode;
	_pos.__pNode->pPrev = pNewNode;

	__size++;

	return (ListNode*)pNewNode;
}

template<typename ELEMENT>
void 
List<ELEMENT>::insert(Iterator _pos, ConstIterator _first, ConstIterator _last)
{
	for(; _first != _last; _first++)
	{
		insert(_pos, *_first);
	}
}

template<typename ELEMENT>
void
List<ELEMENT>::clear()
{
	ListNode* pNodeTemp = NULL;
	NodeBase* pNode = __pMasterNode->pNext;
	while(pNode != __pMasterNode)
	{
		pNodeTemp = (ListNode*)pNode;
		pNode = pNode->pNext;
		destroyNode(pNodeTemp);
	}
	__pMasterNode->pNext = __pMasterNode;
	__pMasterNode->pPrev = __pMasterNode;
	__size = 0;
}

template<typename ELEMENT>
typename List<ELEMENT>::Iterator
List<ELEMENT>::erase(Iterator _pos)
{
	__DCL_ASSERT(_pos != end());
	ListNode* pNodeTemp = (ListNode*)_pos.__pNode;
	NodeBase* pNext = pNodeTemp->pNext;
	pNodeTemp->pPrev->pNext = pNodeTemp->pNext;
	pNodeTemp->pNext->pPrev = pNodeTemp->pPrev;
	destroyNode(pNodeTemp);
	__size--;
	return (ListNode*)pNext;
}

template<typename ELEMENT>
ELEMENT
List<ELEMENT>::removeHead()
{
	__DCL_ASSERT(!isEmpty());
	ELEMENT result = *begin();
	erase(begin());
	return result;
}

template<typename ELEMENT>
ELEMENT
List<ELEMENT>::removeTail()
{
	__DCL_ASSERT(!isEmpty());
	Iterator it = end();
	ELEMENT result = *(--it);
	erase(it);
	return result;
}

template<typename ELEMENT>
void
List<ELEMENT>::move(Iterator _pos, Iterator _first, Iterator _last)
{
	if (_pos != _last)
	{
		_last.__pNode->pPrev->pNext = _pos.__pNode;
		_first.__pNode->pPrev->pNext = _last.__pNode;
		_pos.__pNode->pPrev->pNext = _first.__pNode;

		NodeBase* pTemp = _pos.__pNode->pPrev;
		_pos.__pNode->pPrev = _last.__pNode->pPrev;
		_last.__pNode->pPrev = _first.__pNode->pPrev;
		_first.__pNode->pPrev = pTemp;
	}
}

template<typename ELEMENT>
void
List<ELEMENT>::splice(Iterator _pos, 
		List<ELEMENT>& _other, Iterator _otherFirst, Iterator _otherLast)
{
	size_t nMoveCount = size((ListNode*)(_otherFirst.__pNode),
						(ListNode*)(_otherLast.__pNode));
	__size += nMoveCount;
	_other.__size -= nMoveCount;

	move(_pos, _otherFirst, _otherLast);
}

template<typename ELEMENT>
size_t
List<ELEMENT>::size(ConstIterator _first, ConstIterator _last) const
{
	int nCount = 0;
	for(; _first != _last; _first++)
		nCount++;
	return nCount;
}

#if __DCL_HAVE_THIS_FILE__
	#undef __THIS_FILE__
	#define __THIS_FILE__	__T(__FILE__)
#endif

__DCL_END_NAMESPACE
