
/*
Visual C++ 의 경우 템클레이트 클래스의 맴버 클래스의 맴버들에 
대하여 코드를 생성하지 못하는 버그가 있다.

BUG: LNK2001 on Member Function When Use Nested Class Template
Last reviewed: July 24, 1997
Article ID: Q128789  
The information in this article applies to: 
The Microsoft C/C++ Compiler (CL.EXE) included with:
	- Microsoft Visual C++, 32-bit Edition, versions 2.0, 2.1, 4.0, 4.1, 4.2, 5.0
*/

#ifndef __DCL_LISTED_HASH_MAP_T_H__
#error "Never include <dcl/__ListedHashMapT-MSC.h> directly; use <dcl/ListedHashMapT.h> instead."
#endif

__DCL_BEGIN_NAMESPACE

#if __DCL_HAVE_THIS_FILE__
	static const char_t __szListedHashMapT_h__[] = __T("dcl/__ListedHashMapT-MSC.h");
	#undef __THIS_FILE__
	#define __THIS_FILE__ __szListedHashMapT_h__
#endif

template<typename KEY, typename VALUE, typename HASH_FUN = HashFun<KEY> >
class ListedHashMap : public Object
{
	DECLARE_CLASSINFO(ListedHashMap)
public:
	struct Assoc
	{
		KEY		key;
		VALUE		value;

		Assoc() {}
		Assoc(const KEY& _key, const VALUE& _value)
		{
			this->key = _key;
			this->value = _value;
		}
	};

	/**
	 * @see {@link ListedHashMap#put(constKEY&,constVALUE&,UpdateCallback&) ListedHashMap::put}
	 */
	class UpdateCallback
	{
	protected:
		virtual void onUpdate(const Assoc& _assoc) = 0;
		friend typename ListedHashMap<KEY, VALUE, HASH_FUN>;
	};

	struct HashNode : public Assoc, public NodeBase
	{
		HashNode* pNext;
	};

	class ConstIterator;
	class Iterator : public ListIteratorBase
	{
	public:
		Iterator()
		{
			__pNode = NULL;
		}

		Iterator(NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		Iterator(const Iterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		Iterator& operator=(const Iterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		Iterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		Iterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return Iterator(pSaveNode);
		}

		Iterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		Iterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return Iterator(pSaveNode);
		}

		Assoc& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return *(HashNode*) __pNode;
		}

	protected:
	//	friend typename ListedHashMap<KEY, VALUE, HASH_FUN>;
		friend class ConstIterator;
	};

	class ConstIterator : public ConstListIteratorBase
	{
	public:
		ConstIterator()
		{
			__pNode = NULL;
		}

		ConstIterator(const NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		ConstIterator(const ConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ConstIterator(const Iterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}


		ConstIterator& operator=(const ConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		ConstIterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		ConstIterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return ConstIterator(pSaveNode);
		}

		ConstIterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		ConstIterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return ConstIterator(pSaveNode);
		}

		const Assoc& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return *(HashNode*) __pNode;
		}
	};

	class ConstReverseIterator;
	class ReverseIterator : public ListIteratorBase
	{
	public:
		ReverseIterator()
		{
			__pNode = NULL;
		}

		ReverseIterator(NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		ReverseIterator(const ReverseIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ReverseIterator& operator=(const ReverseIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		ReverseIterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		ReverseIterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return ReverseIterator(pSaveNode);
		}

		ReverseIterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		ReverseIterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return ReverseIterator(pSaveNode);
		}

		Assoc& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return *(HashNode*) __pNode;
		}

	protected:
	//	friend typename ListedHashMap<KEY, VALUE, HASH_FUN>;
		friend class ReverseConstIterator;
	};

	class ReverseConstIterator : public ConstListIteratorBase
	{
	public:
		ReverseConstIterator()
		{
			__pNode = NULL;
		}

		ReverseConstIterator(const NodeBase* _pNode)
		{
			__DCL_ASSERT(_pNode != NULL);
			__pNode = _pNode;
		}

		ReverseConstIterator(const ReverseConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ReverseConstIterator(const ReverseIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
		}

		ReverseConstIterator& operator=(const ReverseConstIterator& _it)
		{
			__DCL_ASSERT(_it.__pNode != NULL);
			__pNode = _it.__pNode;
			return *this;
		}

		ReverseConstIterator& operator++()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pPrev;
			return *this;
		}

		ReverseConstIterator operator++(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pPrev;
			return ReverseConstIterator(pSaveNode);
		}

		ReverseConstIterator& operator--()
		{
			__DCL_ASSERT(__pNode != NULL);
			__pNode = __pNode->pNext;
			return *this;
		}

		ReverseConstIterator operator--(int)
		{
			__DCL_ASSERT(__pNode != NULL);
			const NodeBase* pSaveNode = __pNode;
			__pNode = __pNode->pNext;
			return ReverseConstIterator(pSaveNode);
		}

		const Assoc& operator*()
		{
			__DCL_ASSERT(__pNode != NULL);
			return *(HashNode*) __pNode;
		}
	};

public:
	virtual ~ListedHashMap();
	void initBuckets(size_t _bucketSize);
	ListedHashMap(size_t _bucketSize = 21);

	ListedHashMap(const ListedHashMap& _src);
	const ListedHashMap& operator=(const ListedHashMap& _src);

	ConstIterator begin() const;
	ConstIterator end() const;
	Iterator begin();
	Iterator end();

	ReverseConstIterator rbegin() const;
	ReverseConstIterator rend() const;
	ReverseIterator rbegin();
	ReverseIterator rend();

	size_t bucketSize() const;
	size_t size() const;
	size_t sizeOfBucket(size_t index) const;
	bool isEmpty() const;
	Iterator find(const KEY& _key);
	ConstIterator find(const KEY& _key) const;
	bool lookup(const KEY& _key, VALUE& _rValue) const;
	VALUE& operator[](const KEY&  _key);

	/**
	 * _key와 동일한 노드가 있으면 _value를 변경하기 전에 _cb를 호출한다.
	 */
	void put(const KEY& _key, const VALUE& _value, UpdateCallback& _cb);

	size_t erase(const KEY& _key);
	size_t erase(const Iterator& _it);
	void clear();

protected:
	size_t bucketIndex(const KEY& _key) const;
	HashNode* createNode(const KEY& _key);
	void destroyNode(HashNode* _pNode);

protected:
	NodeBase*		__pMasterNode;
	HASH_FUN		__hashFun;
	size_t				__size;			// count of all elements
	PointerArray		__buckets;

	friend class Iterator;
	friend class ConstIterator;
};

////////////// Inline List Part of ListedHashMap ////////////////////

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ConstIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::begin() const
{
	return __pMasterNode->pNext;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ConstIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::end() const
{
	return __pMasterNode;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::Iterator
ListedHashMap<KEY, VALUE, HASH_FUN>::begin()
{
	return __pMasterNode->pNext;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::Iterator
ListedHashMap<KEY, VALUE, HASH_FUN>::end()
{
	return __pMasterNode;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ReverseConstIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::rbegin() const
{
	return __pMasterNode->pPrev;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ReverseConstIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::rend() const
{
	return __pMasterNode;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ReverseIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::rbegin()
{
	return __pMasterNode->pPrev;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ReverseIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::rend()
{
	return __pMasterNode;
}

////////////// Inline HashMap Part of ListedHashMap  ////////////////////

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
size_t
ListedHashMap<KEY, VALUE, HASH_FUN>::bucketSize() const
{
	return __buckets.size();
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
size_t
ListedHashMap<KEY, VALUE, HASH_FUN>::size() const
{
	return __size;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
bool
ListedHashMap<KEY, VALUE, HASH_FUN>::isEmpty() const
{
	return __size == 0;
}

/////////////////// Implement ListedHashMap //////////////////

// IMPLEMENT_CLASSINFO(ListedHashMap<KEY, VALUE, HASH_FUN>, Object)
#ifdef __DCL_NO_RTTI
template<typename KEY, typename VALUE, typename HASH_FUN>
const Object::ClassInfo ListedHashMap<KEY, VALUE, HASH_FUN>::m_classInfo =
{
	__DCL_NAMESPACE_STRING __S(ListedHashMap),
	sizeof(class ListedHashMap),
	&Object::m_classInfo
};

template<typename KEY, typename VALUE, typename HASH_FUN>
const Object::ClassInfo* ListedHashMap<KEY, VALUE, HASH_FUN>::classInfo() const
{
	return CLASSINFO(class_name);
}
#else
template<typename KEY, typename VALUE, typename HASH_FUN>
const std::type_info& ListedHashMap<KEY, VALUE, HASH_FUN>::typeInfo() const
{
	return typeid(ListedHashMap);
}
#endif

template<typename KEY, typename VALUE, typename HASH_FUN>
ListedHashMap<KEY, VALUE, HASH_FUN>::~ListedHashMap()
{
	clear();
	free (__pMasterNode);
}

template<typename KEY, typename VALUE, typename HASH_FUN>
ListedHashMap<KEY, VALUE, HASH_FUN>::ListedHashMap(size_t _bucketSize /* = 10 */)
	: __buckets(DCLGetNextPrimNumber(_bucketSize))
{
	__pMasterNode = (NodeBase*) malloc(sizeof(NodeBase));
	// FIXME!
	// if (pNode == NULL)
	//		throw new BadAllocException(sizeof(HashNode), __THIS_FILE__, __LINE__);
	__DCL_ASSERT(__pMasterNode != NULL);

	__pMasterNode->pPrev = __pMasterNode;
	__pMasterNode->pNext = __pMasterNode;
	__size = 0;
//	__buckets.resize(DCLGetNextPrimNumber(_bucketSize));
}

template<typename KEY, typename VALUE, typename HASH_FUN>
void
ListedHashMap<KEY, VALUE, HASH_FUN>::initBuckets(size_t _bucketSize)
{
	clear();
	__buckets.resize(DCLGetNextPrimNumber(_bucketSize));
}

template<typename KEY, typename VALUE, typename HASH_FUN>
ListedHashMap<KEY, VALUE, HASH_FUN>::ListedHashMap(const ListedHashMap<KEY, VALUE, HASH_FUN>& _src)
{
	__pMasterNode = (NodeBase*) malloc(sizeof(NodeBase));
	// FIXME!
	// if (pNode == NULL)
	//		throw new BadAllocException(sizeof(HashNode), __THIS_FILE__, __LINE__);
	__DCL_ASSERT(__pMasterNode != NULL);

	__pMasterNode->pPrev = __pMasterNode;
	__pMasterNode->pNext = __pMasterNode;
	__size = 0;

	*this = _src;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
const ListedHashMap<KEY, VALUE, HASH_FUN>&
ListedHashMap<KEY, VALUE, HASH_FUN>::operator=(const ListedHashMap<KEY, VALUE, HASH_FUN>& _src)
{
	if (&_src != this)
	{
		clear();
		__size = _src.__size;
		__buckets.resize(_src.__buckets.size());

		for(size_t index = 0; index < _src.__buckets.size(); index++)
		{
			const HashNode* pNode = (HashNode*) _src.__buckets[index];
			if (pNode != NULL)
			{
				HashNode* pNewNode = createNode(pNode->key);
				pNewNode->value = pNode->value;
				__buckets[index] = pNewNode;
				for(pNode = pNode->pNext; pNode != NULL; pNode = pNode->pNext)
				{
					pNewNode->pNext = createNode(pNode->key);
					pNewNode = pNewNode->pNext;
					pNewNode->value = pNode->value;
				}
			}
		}
	}
	return *this;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
size_t
ListedHashMap<KEY, VALUE, HASH_FUN>::sizeOfBucket(size_t _index) const
{
	__DCL_ASSERT(_index < __buckets.size());

	size_t nCount = 0;
	HashNode* pNode = (HashNode*)__buckets[_index];
	for(; pNode != NULL; pNode = pNode->pNext)
		nCount++;
	return nCount;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
typename ListedHashMap<KEY, VALUE, HASH_FUN>::Iterator
ListedHashMap<KEY, VALUE, HASH_FUN>::find(const KEY& _key)
{
	size_t index = bucketIndex(_key);
	HashNode* pNode = (HashNode*)__buckets[index];
	while (pNode) {
		if (pNode->key == _key) {
			break;
		}
		pNode = pNode->pNext;
	}
	return Iterator(pNode ? (NodeBase*)pNode : __pMasterNode);
}

template<typename KEY, typename VALUE, typename HASH_FUN>
typename ListedHashMap<KEY, VALUE, HASH_FUN>::ConstIterator
ListedHashMap<KEY, VALUE, HASH_FUN>::find(const KEY& _key) const
{
	size_t index = bucketIndex(_key);
	const HashNode* pNode = (HashNode*)__buckets[index];
	while (pNode) {
		if (pNode->key == _key) {
			break;
		}
		pNode = pNode->pNext;
	}
	return ConstIterator(pNode ? (NodeBase*)pNode : __pMasterNode);
}

template<typename KEY, typename VALUE, typename HASH_FUN>
bool
ListedHashMap<KEY, VALUE, HASH_FUN>::lookup(const KEY& _key, VALUE& _rValue) const
{
	size_t index = bucketIndex(_key);
	HashNode* pNode = (HashNode*)__buckets[index];
	while(pNode != NULL) {
		if (pNode->key == _key) {
			_rValue = pNode->value;
			return true;
		}
		pNode = pNode->pNext;
	}
	return false;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
VALUE&
ListedHashMap<KEY, VALUE, HASH_FUN>::operator[](const KEY& _key)
{
	size_t index = bucketIndex(_key);
	HashNode* pFirstNode = (HashNode*)__buckets[index];
	for(HashNode* pCurrentNode = pFirstNode; pCurrentNode!= NULL; 
			pCurrentNode = pCurrentNode->pNext)
	{
		if (pCurrentNode->key == _key)
			return pCurrentNode->value;
	}
	
	HashNode* pNewNode = createNode(_key);
	pNewNode->pNext = pFirstNode;
	__buckets[index] = pNewNode;
	__size++;
	return pNewNode->value;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
void
ListedHashMap<KEY, VALUE, HASH_FUN>
::put(const KEY& _key, const VALUE& _value, UpdateCallback& _cb)
{
	size_t index = bucketIndex(_key);
	HashNode* pFirstNode = (HashNode*)__buckets[index];
	for(HashNode* pCurrentNode = pFirstNode; pCurrentNode!= NULL; 
			pCurrentNode = pCurrentNode->pNext)
	{
		if (pCurrentNode->key == _key)
		{
			_cb.onUpdate(*(Assoc*)pCurrentNode);
			pCurrentNode->value = _value;
			return;
		}
	}
	
	HashNode* pNewNode = createNode(_key);
	pNewNode->pNext = pFirstNode;
	__buckets[index] = pNewNode;
	__size++;
	pNewNode->value = _value;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
inline
size_t
ListedHashMap<KEY, VALUE, HASH_FUN>::bucketIndex(const KEY& _key) const
{
	return __hashFun.hashKey(_key) % __buckets.size();
}

template<typename KEY, typename VALUE, typename HASH_FUN>
typename ListedHashMap<KEY, VALUE, HASH_FUN>::HashNode* 
ListedHashMap<KEY, VALUE, HASH_FUN>::createNode(const KEY& _key)
{
	HashNode* pNode = (HashNode*) malloc(sizeof(HashNode));
	// FIXME!
	// if (pNode == NULL)
	//		throw new BadAllocException(sizeof(HashNode), __THIS_FILE__, __LINE__);
	__DCL_ASSERT(pNode != NULL);

	memset(pNode, 0, sizeof(HashNode));

#if __DCL_HAVE_ALLOC_DEBUG
#undef new
#endif

	new(&(pNode->key)) KEY;
	new(&(pNode->value)) VALUE;

#if __DCL_HAVE_ALLOC_DEBUG
#define new __DCL_DEBUG_NEW
#endif

	((NodeBase*) pNode)->pPrev = __pMasterNode->pPrev;
	((NodeBase*) pNode)->pNext = __pMasterNode;
	__pMasterNode->pPrev->pNext = pNode;
	__pMasterNode->pPrev = pNode;

	pNode->key = _key;
	return pNode;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
void
ListedHashMap<KEY, VALUE, HASH_FUN>::destroyNode(HashNode* _pNode)
{
	((NodeBase*) _pNode)->pPrev->pNext = ((NodeBase*) _pNode)->pNext;
	((NodeBase*) _pNode)->pNext->pPrev = ((NodeBase*) _pNode)->pPrev;

	_pNode->key.~KEY();
	_pNode->value.~VALUE();
	free(_pNode);
}

template<typename KEY, typename VALUE, typename HASH_FUN>
size_t
ListedHashMap<KEY, VALUE, HASH_FUN>::erase(const KEY& _key)
{
	size_t nErased = 0;
	size_t index = bucketIndex(_key);
	HashNode* pCurrentNode = (HashNode*)__buckets[index];
	if (pCurrentNode != NULL)	
	{
		if (pCurrentNode->key == _key)		// first
		{
			__buckets[index] = pCurrentNode->pNext;
			destroyNode(pCurrentNode);
			nErased++;
			__size--;
		}
		else
		{
			HashNode* pNextNode = pCurrentNode->pNext;
			while(pNextNode != NULL)
			{
				if (pNextNode->key == _key)
				{
					pCurrentNode->pNext = pNextNode->pNext;
					destroyNode(pNextNode);
					nErased++;
					__size--;
					break;
				}
				else
				{
					pCurrentNode = pNextNode;
					pNextNode = pCurrentNode->pNext;
				}
			}
		}
	}
	return nErased;
}

template<typename KEY, typename VALUE, typename HASH_FUN>
void
ListedHashMap<KEY, VALUE, HASH_FUN>::clear()
{
	for(size_t i = 0; i < __buckets.size(); i++)
	{
		HashNode* pNode = (HashNode*)__buckets[i];
		while(pNode)
		{
			HashNode* pNext = pNode->pNext;
			destroyNode(pNode);
			pNode = pNext;
		}
		__buckets[i] = NULL;
	}
	__size = 0;
}

#if __DCL_HAVE_THIS_FILE__
	#undef __THIS_FILE__
	#define __THIS_FILE__	__T(__FILE__)
#endif

__DCL_END_NAMESPACE
