#ifdef __DCL_INTERNAL__

#undef _T
#undef CHAR_T
#undef UCHAR_T
#undef BUFFER_T
#undef STRING_T
#undef ARRAY_T

#ifdef __DCL_COMPILE_UNICODE__
    #define _T(s)                   L ## s
    #define CHAR_T                  wchar_t
    #define UCHAR_T                 wint_t
    #define BUFFER_T                CharBuffer
    #define STRING_T                String
    #define STRING_BUILDER_T        StringBuilder
    #define ARRAY_T                 StringArray
#else
    #define _T(s)                   s
    #define CHAR_T                  char
    #define UCHAR_T                 byte_t
    #define BUFFER_T                ByteBuffer
    #define STRING_T                ByteString
    #define STRING_BUILDER_T        ByteStringBuilder
    #define ARRAY_T                 ByteStringArray
#endif

class ARRAY_T;

struct DCLCAPI BUFFER_T
{
    volatile long   __refCount;
    size_t          __allocLength;
    size_t          __dataLength;

    CHAR_T* data() { return (CHAR_T*)(this + 1); }

    long addRef();
    long release();

    static void destroy(BUFFER_T* _buf);

    static BUFFER_T* create(size_t _len);
    static BUFFER_T* create_e(size_t _len);

    static void extend(BUFFER_T*& _buf, size_t _len);
    static void shrink(BUFFER_T*& _buf);

    static void write(BUFFER_T*& _buf, const CHAR_T* _str, size_t _len);
    static void write(BUFFER_T*& _buf, CHAR_T _ch);
    static int vformat(BUFFER_T*& _buf, const CHAR_T* _format, va_list _arglist);
};

class DCLCAPI STRING_T
{
    friend class STRING_BUILDER_T;
protected:
    CHAR_T*     __psz;
    BUFFER_T*   __buf() const { return (BUFFER_T*)__psz - 1; }

    void assignAlloc(size_t _len);

public:
    ~STRING_T();
    STRING_T();
    STRING_T(const STRING_T& _str);
    STRING_T(CHAR_T _ch, size_t _repeat = 1);
    STRING_T(const CHAR_T* _ps, size_t _start, size_t _len);
    STRING_T(const CHAR_T* _psz, size_t _len = (size_t)-1);
    STRING_T(const CHAR_T* _begin, const CHAR_T* _end);
    STRING_T(BUFFER_T* _buf);

    STRING_T& assign(const STRING_T& _str);
    STRING_T& assign(CHAR_T _ch, size_t _repeat = 1);
    STRING_T& assign(const CHAR_T* _ps, size_t _start, size_t _len);
    STRING_T& assign(const CHAR_T* _psz, size_t _len = (size_t)-1);
    STRING_T& assign(const CHAR_T* _begin, const CHAR_T* _end);
    STRING_T& assign(BUFFER_T* _buf);

    STRING_T& operator = (const STRING_T& _str);
    STRING_T& operator = (const CHAR_T* _psz);
    STRING_T& operator = (CHAR_T _ch);
    STRING_T& operator = (BUFFER_T* _buf);

    void clear();

protected:
    void assign(const CHAR_T* _ps1, size_t _len1, const CHAR_T* _ps2, size_t _len2);

    DCLCAPI friend STRING_T operator + (const STRING_T& _str1, const STRING_T& _str2);
    DCLCAPI friend STRING_T operator + (const STRING_T& _str, CHAR_T _ch);
    DCLCAPI friend STRING_T operator + (CHAR_T _ch, const STRING_T& _str);
    DCLCAPI friend STRING_T operator + (const STRING_T& _str, const CHAR_T* _psz);
    DCLCAPI friend STRING_T operator + (const CHAR_T* _psz, const STRING_T& _str);

public:
    // return (size_t)-1 not found
    size_t indexOf(CHAR_T _ch, size_t _start = 0) const;
    size_t indexOf(const CHAR_T* _psz, size_t _start = 0) const;
    size_t indexOf(const STRING_T& _str, size_t _start = 0) const;
    size_t lastIndexOf(CHAR_T _ch, size_t _start = 0) const;
    size_t lastIndexOf(const STRING_T& _str, size_t _start = 0) const;
    size_t lastIndexOf(const CHAR_T* _psz, size_t _start = 0) const;

    bool contains(CHAR_T _ch) const;
    bool contains(const CHAR_T* _psz) const;
    bool contains(const STRING_T& _str) const;

    bool endsWith(const CHAR_T* _suffix) const;
    bool startsWith(const CHAR_T* _prefix) const;
    bool endsWith(const STRING_T& _suffix) const;
    bool startsWith(const STRING_T& _prefix) const;

    int compare(const CHAR_T* _psz, size_t _len = (size_t)-1) const;
    int compareNoCase(const CHAR_T* _psz, size_t _len = (size_t)-1) const;
    static int compare(const CHAR_T* psz1, const CHAR_T* psz2, size_t _len = (size_t)-1);
    static int compareNoCase(const CHAR_T* psz1, const CHAR_T* psz2, size_t _len = (size_t)-1);

    STRING_T mid(size_t _first, size_t _len = (size_t)-1) const;    // _len == -1 then 나머지 전부
    STRING_T left(size_t _len) const;
    STRING_T right(size_t _len) const;

    STRING_T substring(size_t _first) const;
    STRING_T substring(size_t _first, size_t _last) const;

    STRING_T padCenter(size_t _len, CHAR_T _ch) const;
    STRING_T padLeft(size_t _len, CHAR_T _ch) const;
    STRING_T padRight(size_t _len, CHAR_T _ch) const;

    STRING_T replace(size_t _start, size_t _len,
                const CHAR_T* _new, size_t _newlen = (size_t)-1) const;
    STRING_T replace(size_t _start, const STRING_T& _new) const;
    STRING_T rreplace(size_t _start, size_t _len,
                const CHAR_T* _new, size_t _newlen = (size_t)-1) const;
    STRING_T rreplace(size_t _start, const STRING_T& _new) const;

    STRING_T replace(CHAR_T _old, CHAR_T _new) const;
    STRING_T replace(const CHAR_T* _old, const CHAR_T* _new) const;
    STRING_T replace(const STRING_T& _old, const STRING_T& _new) const;
    STRING_T replace(const CHAR_T* _old, size_t _oldlen,
                const CHAR_T* _new, size_t _newlen) const;

    size_t search(
            const CHAR_T* _regex,
            bool _icase
            ) const
        __DCL_THROWS1(RegexException*);

    size_t search(
            const STRING_T& _regex,
            bool _icase
            ) const
        __DCL_THROWS1(RegexException*);

    STRING_T substring(
            const CHAR_T* _regex,
            bool _icase
        ) const
        __DCL_THROWS1(RegexException*);

    STRING_T substring(
            const STRING_T& _regex,
            bool _icase
        ) const
        __DCL_THROWS1(RegexException*);

    bool searches(
            const CHAR_T* _regex,
            bool _icase
            ) const
        __DCL_THROWS1(RegexException*);

    bool searches(
            const STRING_T& _regex,
            bool _icase
            ) const
        __DCL_THROWS1(RegexException*);

    bool matches(
            const CHAR_T* _regex,
            bool _icase
            ) const
        __DCL_THROWS1(RegexException*);

    bool matches(
            const STRING_T& _regex,
            bool _icase
            ) const
        __DCL_THROWS1(RegexException*);

    STRING_T replace_r(
            const CHAR_T* _regex,
            const CHAR_T* _replacment,
            bool _icase,
            size_t _limit = (size_t)-1
            ) const
        __DCL_THROWS1(RegexException*);

    STRING_T replace_r(
            const STRING_T& _regex,
            const STRING_T& _replacement,
            bool _icase,
            size_t _limit = (size_t)-1
            ) const
        __DCL_THROWS1(RegexException*);

    ARRAY_T& split_r(
            const CHAR_T* _regex,
            bool _icase,
            ARRAY_T& _results,
            size_t _limit = (size_t)-1
            ) const
        __DCL_THROWS1(RegexException*);

    ARRAY_T& split_r(
            const STRING_T& _regex,
            bool _icase ,
            ARRAY_T& _results,
            size_t _limit = (size_t)-1) const
        __DCL_THROWS1(RegexException*);

    STRING_T toUpperCase() const;
    STRING_T toLowerCase() const;
#ifdef __DCL_INCLUDED_LOCALE_H
    STRING_T toUpperCase(locale_t _locale) const;
    STRING_T toLowerCase(locale_t _locale) const;
#endif
    String toString() const;

    STRING_T trim() const;
    STRING_T trimLeft() const;
    STRING_T trimRight() const;
    STRING_T trim(const CHAR_T* _chars) const;
    STRING_T trimLeft(const CHAR_T* _chars) const;
    STRING_T trimRight(const CHAR_T* _chars) const;

    bool isEmpty() const;
    size_t length() const;
    const CHAR_T* data() const;
    operator const CHAR_T* () const;
    CHAR_T operator[](size_t _index) const;

    static size_t length(const CHAR_T* _psz, size_t _max = (size_t)-1);

    static STRING_T format(const CHAR_T* _format, ...);

    enum EscapeFlags {
        ESCAPE_DEFAULT,         // ASCII_0 ~ ASCII_31, ASCII_127 ~ 256, " ' / \ ?
        ESCAPE_EXTENDED,        // exclusive 0~9 a~z A~Z
        ESCAPE_ALL,
        ESCAPE_XML              // &<>"'
    };

    static STRING_T escape(
        const CHAR_T*       _ps,
        size_t              _len,
        EscapeFlags         _flag       = ESCAPE_DEFAULT
        );

    static STRING_T unescape(
        const CHAR_T*       _psz,
        size_t              _len
        );

    static STRING_T toHexString(    // "\x..."
        const char*         _bytes,
        size_t              _len,
        size_t              _max    = (size_t)-1,
        bool                _prefix = true
        );

    static STRING_T toHexString(
        const ByteString&   _bytes,
        size_t              _max    = (size_t)-1,
        bool                _prefix = true
        );

    static STRING_T tryString(
        const char*         _bytes,
        size_t              _len,
        size_t              _max    = (size_t)-1
        );

    static STRING_T tryString(
        const ByteString&   _bytes,
        size_t              _max    = (size_t)-1
    );

    static CHAR_T* find(
        const CHAR_T*       _begin,
        const CHAR_T*       _end,
        CHAR_T              _ch
        );

    static CHAR_T* rfind(
        const CHAR_T*       _begin,
        const CHAR_T*       _end,
        CHAR_T              _ch
        );

    // find '\0' included string 
    static CHAR_T* find(
        const CHAR_T*       _begin,
        const CHAR_T*       _end,
        const CHAR_T*       _sub,
        size_t              _sublen
        );

    static CHAR_T* rfind(
        const CHAR_T*       _begin,
        const CHAR_T*       _end,
        const CHAR_T*       _sub,
        size_t              _sublen
        );

    static size_t split(
        const CHAR_T*       _begin,
        const CHAR_T*       _end,
        const CHAR_T*       _delimiter,
        size_t              _delimiterlen,
        ARRAY_T&            _results,
        size_t              _limit     = (size_t)-1
        );

    static size_t split(
        const CHAR_T*       _begin,
        const CHAR_T*       _end,
        CHAR_T              _delimiter,
        ARRAY_T&            _results,
        size_t              _limit     = (size_t)-1
        );

    size_t split(
        const STRING_T&     _delimiter,
        ARRAY_T&            _results,
        size_t              _limit     = (size_t)-1
        ) const;

    size_t split(
        CHAR_T              _delimiter,
        ARRAY_T&            _results,
        size_t              _limit     = (size_t)-1
        ) const;

    static STRING_T join(
        const ARRAY_T&      _array,
        CHAR_T              _delimiter,
        bool                _hasEmpty = false
        );

    static STRING_T valueOf(bool _b);
    static STRING_T valueOf(char _n);
    static STRING_T valueOf(unsigned char _n);
    static STRING_T valueOf(short _n);
    static STRING_T valueOf(unsigned short _n);
    static STRING_T valueOf(int _n);
    static STRING_T valueOf(unsigned int _n);
    static STRING_T valueOf(long _n);
    static STRING_T valueOf(unsigned long _n);
    static STRING_T valueOf(long long _n);
    static STRING_T valueOf(unsigned long long _n);
    static STRING_T valueOf(float _n);
    static STRING_T valueOf(double _n);
	static STRING_T valueOf(long double _n);
};

inline STRING_T& STRING_T::operator = (const STRING_T& _str)
{
    return assign(_str);
}

inline STRING_T& STRING_T::operator = (const CHAR_T* _psz)
{
    return assign(_psz, (size_t)-1);
}

inline STRING_T& STRING_T::operator = (CHAR_T _ch)
{
    return assign(&_ch, 1);
}

inline STRING_T& STRING_T::operator = (BUFFER_T* _buf)
{
    return assign(_buf);
}

inline int STRING_T::compare(const CHAR_T* _psz, size_t _len) const
{
    return STRING_T::compare(__psz, _psz, _len);
}

inline int STRING_T::compareNoCase(const CHAR_T* _psz, size_t _len) const
{
    return STRING_T::compareNoCase(__psz, _psz, _len);
}
// ==
DCLCAPI inline bool operator == (const STRING_T& _str1, const STRING_T& _str2)
{
    return _str1.length() == _str2.length() ? _str1.compare(_str2) == 0 : false;
}

DCLCAPI inline bool operator == (const STRING_T& _str1, const CHAR_T* _psz)
{
    return _str1.compare(_psz) == 0;
}

DCLCAPI inline bool operator == (const CHAR_T* _psz, const STRING_T& _str2)
{
    return _str2.compare(_psz) == 0;
}

DCLCAPI inline bool operator == (const STRING_T& _str1, CHAR_T _ch)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str1.compare(sz) == 0;
}

DCLCAPI inline bool operator == (CHAR_T _ch, const STRING_T& _str2)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str2.compare(sz) == 0;
}
// !=
DCLCAPI inline bool operator != (const STRING_T& _str1, const STRING_T& _str2)
{
    return _str1.length() == _str2.length() ? _str1.compare(_str2) != 0 : true;
}

DCLCAPI inline bool operator != (const STRING_T& _str, const CHAR_T* _psz)
{
    return _str.compare(_psz) != 0;
}

DCLCAPI inline bool operator != (const CHAR_T* _psz, const STRING_T& _str2)
{
    return _str2.compare(_psz) != 0;
}

DCLCAPI inline bool operator != (const STRING_T& _str1, CHAR_T _ch)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str1.compare(sz) != 0;
}

DCLCAPI inline bool operator != (CHAR_T _ch, const STRING_T& _str2)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str2.compare(sz) != 0;
}
// >
DCLCAPI inline bool operator > (const STRING_T& _str1, const STRING_T& _str2)
{
    ssize_t n = _str1.length() - _str2.length();
    return n == 0 ? _str1.compare(_str2) > 0 : n > 0;
}

DCLCAPI inline bool operator > (const STRING_T& _str1, const CHAR_T* _psz)
{
    return _str1.compare(_psz) > 0;
}

DCLCAPI inline bool operator > (const CHAR_T* _psz, const STRING_T& _str2)
{
    return _str2.compare(_psz) < 0;
}

DCLCAPI inline bool operator > (const STRING_T& _str1, CHAR_T _ch)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str1.compare(sz) > 0;
}

DCLCAPI inline bool operator > (CHAR_T _ch, const STRING_T& _str2)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str2.compare(sz) < 0;
}
// <
DCLCAPI inline bool operator < (const STRING_T& _str1, const STRING_T& _str2)
{
    ssize_t n = _str1.length() - _str2.length();
    return n == 0 ? _str1.compare(_str2) < 0 : n < 0;
}

DCLCAPI inline bool operator < (const STRING_T& _str1, const CHAR_T* _psz)
{
    return _str1.compare(_psz) < 0;
}

DCLCAPI inline bool operator < (const CHAR_T* _psz, const STRING_T& _str2)
{
    return _str2.compare(_psz) > 0;
}

DCLCAPI inline bool operator < (const STRING_T& _str1, CHAR_T _ch)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str1.compare(sz) < 0;
}

DCLCAPI inline bool operator < (CHAR_T _ch, const STRING_T& _str2)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str2.compare(sz) > 0;
}
// >=
DCLCAPI inline bool operator >= (const STRING_T& _str1, const STRING_T& _str2)
{
    return _str1.compare(_str2) >= 0;
}

DCLCAPI inline bool operator >= (const STRING_T& _str1, const CHAR_T* _psz)
{
    return _str1.compare(_psz) >= 0;
}

DCLCAPI inline bool operator >= (const CHAR_T* _psz, const STRING_T& _str2)
{
    return _str2.compare(_psz) <= 0;
}

DCLCAPI inline bool operator >= (const STRING_T& _str1, CHAR_T _ch)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str1.compare(sz) >= 0;
}

DCLCAPI inline bool operator >= (CHAR_T _ch, const STRING_T& _str2)
{
    CHAR_T sz[2] = { _ch, 0};
    return _str2.compare(sz) <= 0;
}
// <=
DCLCAPI inline bool operator <= (const STRING_T& _str1, const STRING_T& _str2)
{
    return _str1.compare(_str2) <= 0;
}

DCLCAPI inline bool operator <= (const STRING_T& _str1, const CHAR_T* _psz)
{
    return _str1.compare(_psz) <= 0;
}

DCLCAPI inline bool operator <= (const CHAR_T* _psz, const STRING_T& _str2)
{
    return _str2.compare(_psz) >= 0;
}

DCLCAPI inline bool operator <= (const STRING_T& _str1, CHAR_T _ch)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str1.compare(sz) <= 0;
}

DCLCAPI inline bool operator <= (CHAR_T _ch, const STRING_T& _str2)
{
    CHAR_T sz[2] = { _ch, 0 };
    return _str2.compare(sz) >= 0;
}

inline bool STRING_T::contains(CHAR_T _ch) const
{
    return indexOf(_ch, 0) != (size_t)-1;
}

inline bool STRING_T::contains(const CHAR_T* _psz) const
{
    return indexOf(_psz, 0) != (size_t)-1;
}

inline bool STRING_T::contains(const STRING_T& _str) const
{
    return indexOf(_str, 0) != (size_t)-1;
}

inline bool STRING_T::endsWith(const CHAR_T* _suffix) const
{
    size_t len = STRING_T::length(_suffix);
    return length() >= len &&
        STRING_T::compare(__psz + length() - len,
            _suffix, len) == 0;
}

inline bool STRING_T::startsWith(const CHAR_T* _prefix) const {
    return STRING_T::compare(__psz, _prefix, STRING_T::length(_prefix)) == 0;
}

inline bool STRING_T::endsWith(const STRING_T& _suffix) const
{
    return length() >= _suffix.length() &&
        STRING_T::compare(__psz + length() - _suffix.length(),
            _suffix.__psz, _suffix.length()) == 0;
}

inline bool STRING_T::startsWith(const STRING_T& _prefix) const
{
    return STRING_T::compare(__psz, _prefix.__psz, _prefix.length()) == 0;
}

inline STRING_T STRING_T::substring(size_t _first) const
{
    return mid(_first);
}

inline STRING_T STRING_T::substring(size_t _first, size_t _last) const
{
    return mid(_first, _last - _first);
}

inline STRING_T STRING_T::replace(size_t _start, const STRING_T& _new) const
{
    return replace(_start, _new.length(), _new, _new.length());
}

inline STRING_T STRING_T::rreplace(size_t _start, const STRING_T& _new) const
{
    return rreplace(_start, _new.length(), _new, _new.length());
}

inline STRING_T STRING_T::replace(const CHAR_T* _old, const CHAR_T* _new) const
{
    return replace(_old, STRING_T::length(_old),
            _new, STRING_T::length(_new));
}

inline STRING_T STRING_T::replace(const STRING_T& _old, const STRING_T& _new) const
{
    return replace(_old, _old.length(), _new, _new.length());
}

inline bool STRING_T::isEmpty() const
{
    return length() == 0;
}

inline size_t STRING_T::length() const
{
    return __buf()->__dataLength;
}

inline const CHAR_T* STRING_T::data() const
{
    return __psz;
}

inline STRING_T::operator const CHAR_T* () const
{
    return __psz;
}

inline STRING_T STRING_T::toHexString(
        const ByteString&   _bytes,
        size_t              _max,    // = (size_t)-1,
        bool                _prefix    // = true
        )
{
    return STRING_T::toHexString(_bytes, _bytes.length(), _max, _prefix);
}

inline STRING_T STRING_T::tryString(
        const ByteString&   _bytes,
        size_t              _max    // = (size_t)-1,
        )
{
    return STRING_T::tryString(_bytes, _bytes.length(), _max);
}

inline size_t STRING_T::split(
        const STRING_T&     _delimiter,
        ARRAY_T&            _results,
        size_t              _limit    //    = (size_t)-1
        ) const
{
    return STRING_T::split(
            __psz, __psz + length(),
            _delimiter.__psz, _delimiter.length(),
            _results,
            _limit
            );
    }

inline size_t STRING_T::split(
        CHAR_T              _delimiter,
        ARRAY_T&            _results,
        size_t              _limit    //    = (size_t)-1
        ) const
{
    return STRING_T::split(
            __psz, __psz + length(),
            _delimiter,
            _results,
            _limit
            );
}

#undef _T
#undef CHAR_T
#undef UCHAR_T
#undef BUFFER_T
#undef STRING_T
#undef STRING_BUILDER_T
#undef ARRAY_T

#endif            // __DCL_INTERNAL_
