#ifdef __DCL_INTERNAL__

#undef _T
#undef CHAR_T
#undef UCHAR_T
#undef BUFFER_T
#undef STRING_T
#undef STRING_BUILDER_T

#ifdef __DCL_COMPILE_UNICODE__
    #define _T(s)                   L ## s
    #define CHAR_T                  wchar_t
    #define UCHAR_T                 wint_t
    #define BUFFER_T                CharBuffer
    #define STRING_T                String
    #define STRING_BUILDER_T        StringBuilder
#else
    #define _T(s)                   s
    #define CHAR_T                  char
    #define UCHAR_T                 byte_t
    #define BUFFER_T                ByteBuffer
    #define STRING_T                ByteString
    #define STRING_BUILDER_T        ByteStringBuilder
#endif

class DCLCAPI STRING_BUILDER_T
{
protected:
    CHAR_T*     __psz;
    BUFFER_T*   __buf() const { return (BUFFER_T*)__psz - 1; }

    void assignAlloc(size_t _len);
    void updateAlloc(size_t _len = 0);

public:
    ~STRING_BUILDER_T();
    STRING_BUILDER_T(size_t _capacity = 32);
    STRING_BUILDER_T(const STRING_BUILDER_T& _sb);
    STRING_BUILDER_T(const STRING_T& _str);
    STRING_BUILDER_T(CHAR_T _ch, size_t _repeat = 1);
    STRING_BUILDER_T(const CHAR_T* _ps, size_t _start, size_t _len);
    STRING_BUILDER_T(const CHAR_T* _psz, size_t _len = (size_t)-1);
    STRING_BUILDER_T(const CHAR_T* _begin, const CHAR_T* _end);

    STRING_BUILDER_T& assign(const STRING_BUILDER_T& _sb);
    STRING_BUILDER_T& assign(const STRING_T& _str);
    STRING_BUILDER_T& assign(CHAR_T _ch, size_t _repeat = 1);
    STRING_BUILDER_T& assign(const CHAR_T* _ps, size_t _start, size_t _len);
    STRING_BUILDER_T& assign(const CHAR_T* _psz, size_t _len = (size_t)-1);
    STRING_BUILDER_T& assign(const CHAR_T* _begin, const CHAR_T* _end);

    STRING_BUILDER_T& operator = (const STRING_T& _str);
    STRING_BUILDER_T& operator = (const CHAR_T* _psz);
    STRING_BUILDER_T& operator = (CHAR_T _ch);

    STRING_BUILDER_T& append(const STRING_BUILDER_T& _sb);
    STRING_BUILDER_T& append(const STRING_T& _str);
    STRING_BUILDER_T& append(CHAR_T _ch, size_t _repeat = 1);
    STRING_BUILDER_T& append(const CHAR_T* _ps, size_t _start, size_t _len);
    STRING_BUILDER_T& append(const CHAR_T* _psz, size_t _len = (size_t)-1);
    STRING_BUILDER_T& append(const CHAR_T* _begin, const CHAR_T* _end);

    STRING_BUILDER_T& operator += (const STRING_BUILDER_T& _sb);
    STRING_BUILDER_T& operator += (const STRING_T& _str);
    STRING_BUILDER_T& operator += (CHAR_T _ch);
    STRING_BUILDER_T& operator += (const CHAR_T* _psz);

    STRING_BUILDER_T& format(const CHAR_T* _format, ...);

    STRING_BUILDER_T& erase(size_t _start, size_t _len);
    STRING_BUILDER_T& replace(size_t _start, size_t _len,
                    const CHAR_T* _new, size_t _newlen = (size_t)-1);
    STRING_BUILDER_T& replace(size_t _start, const STRING_T& _new);

    STRING_BUILDER_T& rreplace(size_t _start, size_t _len,
                    const CHAR_T* _new, size_t _newlen = (size_t)-1);
    STRING_BUILDER_T& rreplace(size_t _start, const STRING_T& _new);

    STRING_BUILDER_T& reverse();

    STRING_BUILDER_T& insert(size_t _index, CHAR_T _ch);
    STRING_BUILDER_T& insert(size_t _index, const CHAR_T* _psz, size_t _len = (size_t)-1);

#ifndef __DCL_COMPILE_UNICODE__
    ByteString toByteString() const;
#endif
    String toString() const;
    operator STRING_T () const;
    
    STRING_BUILDER_T& trim();
    STRING_BUILDER_T& trimLeft();
    STRING_BUILDER_T& trimRight();
    STRING_BUILDER_T& trim(const CHAR_T* _chars);
    STRING_BUILDER_T& trimLeft(const CHAR_T* _chars);
    STRING_BUILDER_T& trimRight(const CHAR_T* _chars);

    STRING_BUILDER_T& reset();
    STRING_BUILDER_T& shrink();

    size_t capacity() const;
    bool isEmpty() const;
    size_t length() const;
    const CHAR_T* data() const;
    operator const CHAR_T* () const;
    CHAR_T operator[](size_t _index) const;
    CHAR_T& operator[](size_t _index);
};

inline STRING_BUILDER_T& STRING_BUILDER_T::operator = (const STRING_T& _str)
{
    return assign(_str);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::operator = (const CHAR_T* _psz)
{
    return assign(_psz, (size_t)-1);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::operator = (CHAR_T _ch)
{
    return assign(&_ch, 1);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::operator += (const STRING_BUILDER_T& _sb)
{
    return append(_sb);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::operator += (const STRING_T& _str)
{
    return append(_str);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::operator += (CHAR_T _ch)
{
    return append(_ch);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::operator += (const CHAR_T* _psz)
{
    return append(_psz);
}

inline STRING_BUILDER_T& STRING_BUILDER_T::replace(size_t _start, const STRING_T& _new)
{
    return replace(_start, _new.length(), _new, _new.length());
}

inline STRING_BUILDER_T& STRING_BUILDER_T::rreplace(size_t _start, const STRING_T& _new)
{
    return rreplace(_start, _new.length(), _new, _new.length());
}

#ifdef __DCL_COMPILE_UNICODE__
inline STRING_BUILDER_T::operator String () const
{
    return toString();
}
#else
inline STRING_BUILDER_T::operator ByteString () const
{
    return toByteString();
}
#endif

inline size_t STRING_BUILDER_T::capacity() const
{
    return __buf()->__allocLength;
}

inline bool STRING_BUILDER_T::isEmpty() const
{
    return length() == 0;
}

inline size_t STRING_BUILDER_T::length() const
{
    return __buf()->__dataLength;
}

inline const CHAR_T* STRING_BUILDER_T::data() const
{
    return __psz;
}

inline STRING_BUILDER_T::operator const CHAR_T* () const
{
    return __psz;
}

#undef _T
#undef CHAR_T
#undef UCHAR_T
#undef BUFFER_T
#undef STRING_T
#undef STRING_BUILDER_T

#endif      // __DCL_INTERNAL_
