#ifndef __DCL_DLFCN_H__
#define __DCL_DLFCN_H__		20110918

#include <dlfcn.h>

__DCL_BEGIN_NAMESPACE

class String;

/**
 * dlopen을 wrapping한다
 * <p>dlopen을 호출하기전에 _filename을 다중바이트문자열로 변환한다.
 * 변환에 실패하면 errno를 EILSEQ로 설정하고 NULL을 반환한다.<p>
 * <p>만약, errno가 0이면 dlopen에서 오류가 발생한 것이다.
 * 이 경우 __dlerror()으로 에러메시지를 얻을 수 있다</p>
 */
DCLCAPI void* __dlopen(const String& _filename, int _flag);

/**
 * dlopen(), dlsym(), dlclose()가 실패할 경우 에러메지시를 얻는다.
 * <p>성공하면 r에 에러메시지를 저장하고 0을 반환한다.
 * 실패하면 errno를 0으로 설정하고 -1을 반환한다.</p>
 */
DCLCAPI int __dlerror(String& r);

__DCL_END_NAMESPACE

#endif		// __DCL_DLFCN_H__
