#ifndef __DCL_REGEX_WRAP
#define __DCL_REGEX_WRAP
// ref: http://www.boost.org

__DCL_BEGIN_NAMESPACE

class String;
class ByteString;
class StringArray;
class ByteStringArray;

typedef void*	regex_handle;

regex_handle __regex_create();
void __regex_destroy(regex_handle _handle);

enum regex_compile_flags {
	regex_icase		= 0x0001,
	regex_nosubs	= 0x0002,
	regex_newline	= 0x0004
};

// typedef boost::regex_error public std::runtime_error
// typedef boost::regex_error boost::bad_pattern
void __regex_compile(
		regex_handle _handle,
		const wchar_t* _pattern, size_t _n,
		unsigned int _flags
		); // throws(boost::bad_expression&)

struct match_result
{
	const wchar_t*	first;
	const wchar_t*	second;
	bool			matched;
};

enum regex_match_flags {
	regex_not_bol	= 0x0001,
	regex_not_eol	= 0x0002
};

void __matches_free(match_result* _results);

size_t __regex_match(
			regex_handle _handle,
			const wchar_t* _begin, const wchar_t* _end,
			match_result** _results, unsigned int _flags
			); // throws(std::runtime_error&)

bool __regex_match(
			regex_handle _handle,
			const wchar_t* _begin, const wchar_t* _end,
			unsigned int _flags
			); // throws(std::runtime_error&)

bool __regex_search(
			regex_handle _handle,
			const wchar_t* _begin, const wchar_t* _end,
			match_result** _results, unsigned int _flags
			); // throws(std::runtime_error&)

bool __regex_search(
			regex_handle _handle,
			const wchar_t* _begin, const wchar_t* _end,
			unsigned int _flags
			);	// throws(std::runtime_error&)

bool __regex_matches(
		const wchar_t* _regex, const wchar_t* _regexend,
		const wchar_t* _begin, const wchar_t* _end,
		bool _icase
		) __DCL_THROWS1(RegexException*);

bool __regex_matches(
		const char* _regex, const char* _regexend,
		const char* _begin, const char* _end,
		bool _icase
		) __DCL_THROWS1(RegexException*);

size_t __regex_search(
	const wchar_t* _regex, const wchar_t* _regexend,
	const wchar_t* _begin, const wchar_t* _end,
	bool _icase
) __DCL_THROWS1(RegexException*);

size_t __regex_search(
	const char* _regex, const char* _regexend,
	const char* _begin, const char* _end,
	bool _icase
) __DCL_THROWS1(RegexException*);

String __regex_substring(
	const wchar_t* _regex, const wchar_t* _regexend,
	const wchar_t* _begin, const wchar_t* _end,
	bool _icase
) __DCL_THROWS1(RegexException*);

ByteString __regex_substring(
	const char* _regex, const char* _regexend,
	const char* _begin, const char* _end,
	bool _icase
) __DCL_THROWS1(RegexException*);

String __regex_replace(
		const wchar_t* _regex, const wchar_t* _regexend,
		const wchar_t* _begin, const wchar_t* _end,
		const wchar_t* _replacement, const wchar_t* _replacementend,
		bool _icase,
		size_t _limit = (size_t)-1
		) __DCL_THROWS1(RegexException*);

ByteString __regex_replace(
		const char* _regex, const char* _regexend,
		const char* _begin, const char* _end,
		const char* _replacement, const char* _replacementend,
		bool _icase,
		size_t _limit = (size_t)-1
		) __DCL_THROWS1(RegexException*);

StringArray& __regex_split(
		const wchar_t* _regex, const wchar_t* _regexend,
		const wchar_t* _begin, const wchar_t* _end,
		bool _icase,
		StringArray& _results,
		size_t _limit = (size_t)-1
		) __DCL_THROWS1(RegexException*);

ByteStringArray& __regex_split(
		const char* _regex, const char* _regexend,
		const char* _begin, const char* _end,
		bool _icase,
		ByteStringArray& _results,
		size_t _limit = (size_t)-1
		) __DCL_THROWS1(RegexException*);

__DCL_END_NAMESPACE

#endif		// __DCL_REGEX_WRAP

