#ifndef __DCL_STDLIB_H__
#define __DCL_STDLIB_H__	20110918

#ifndef __DCL_CONFIG_H__
#include <dcl/Config.h>
#endif

#include <stdlib.h>

__DCL_BEGIN_NAMESPACE

class String;

/**
 *	@return == NULL or -1, see errno
 */

/**
 * 환경변수에서 일치하는 것이 없으면 errno를 ENOENT로 설정하고 -1을 반환한다
 */
#if __DCL_WINDOWS
DCLCAPI int setenv(const char* _name, const char* _value, int _overwrite);
DCLCAPI int unsetenv(const char* _name);
#endif

DCLCAPI int __getenv(const String& _name, String& _value);
DCLCAPI int __setenv(const String& _name, const String& _value, bool _overwrite = true);
DCLCAPI int __unsetenv(const String& _name);

DCLCAPI int __realpath(const String& _path, String& _resolved);

__DCL_END_NAMESPACE

#endif	// __DCL_STDLIB_H__

