#ifndef __DEBUG_H__
#define __DEBUG_H__

#include <stdio.h>
#include <stdarg.h>

#if __DCL_WINDOWS
#define __DEBUG_TRACE__ "D:/temp/dcl_hsc_ap2.txt"
#else
#define __DEBUG_TRACE__ "/dev/pts/0"
#endif

#ifndef __THIS_FILE__
#define __THIS_FILE__	__FILE__
#endif

static void trace(const char* fmt, ...)
{
	va_list args;
	FILE* fp = fopen(__DEBUG_TRACE__, "a");
	if (fp)
	{
#if __DCL_DEBUG
		fprintf(fp, "D ");
#else
		fprintf(fp, "R ");
#endif
		va_start(args, fmt);
		vfprintf(fp, fmt, args);
		va_end(args);
		fclose(fp);
	}
}

#define _TRACE0(str) \
	trace("%s(%d) %s: %s", __THIS_FILE__, __LINE__, __PRETTY_FUNCTION__, str)
#define _TRACE1(fmt, arg1) \
	trace("%s(%d) %s: " fmt, __THIS_FILE__, __LINE__, __PRETTY_FUNCTION__, arg1)
#define _TRACE2(fmt, arg1, arg2) \
	trace("%s(%d) %s: " fmt, __THIS_FILE__, __LINE__, __PRETTY_FUNCTION__, arg1, arg2)
#define _TRACE3(fmt, arg1, arg2, arg3) \
	trace("%s(%d) %s: " fmt, __THIS_FILE__, __LINE__, __PRETTY_FUNCTION__, arg1, arg2, arg3)

#endif