#ifndef __DCL_UNISTD_H__
#define __DCL_UNISTD_H__	20100119

#include <unistd.h>

__DCL_BEGIN_NAMESPACE

class String;

/**
 *	@return == NULL or -1, see errno
 */
DCLCAPI int __access(const String& _path, int _type);
DCLCAPI int __chown(const String& _path, uid_t _owner, gid_t _group);
DCLCAPI int __lchown(const String& _path, uid_t _owner, gid_t _group);
DCLCAPI int __chdir(const String& _path);
DCLCAPI int __getcwd(String& _r);	
DCLCAPI int __ttyname(int fd, String& _r);
DCLCAPI int __link(const String& _from, const String& _to);
DCLCAPI int __symlink(const String& _from, const String& _to);
DCLCAPI ssize_t __readlink(const String& _path, String& _r);
DCLCAPI int __unlink(const String& _path);
DCLCAPI int __rmdir(const String& _path);
DCLCAPI int __getlogin(String& _r);
DCLCAPI int __gethostname(String& r);
DCLCAPI int __getdomainname(String _r);
DCLCAPI int __truncate(const String& _path, off_t _len);

__DCL_END_NAMESPACE

#endif		// __DCL_UNISTD_H__
