#ifndef __DCL_SIZE_T_H__
#define __DCL_SIZE_T_H__		20110222

#ifndef __DCL_CONFIG_H__
#include <dcl/Config.h>
#endif

__DCL_BEGIN_NAMESPACE

/**
 * 이 파일은 size_t과 관련하여 기본 inline 함수를 정의한다.
 */

 /**
 * x + y 의 결과는 size_t 값의 범위를 넘을 수 있다. 결과의 최대값은 항상 (size_t) -1 이다.
 * available()의 구현에서 사용된다.
 */
inline size_t __ADD_OVERFLOW_MAX(size_t x, size_t y)
{
	// x에 더할 수 있는 값 보다 y가 크면 -1이다.
	return ((size_t)-1 - x) < y ? (size_t)-1 : x + y;
}

/**
 * 최소값을 리턴한다.
 */
inline size_t __MIN(size_t x, size_t y)
{
	return x < y ? x : y;
}

/**
 * 최소값을 리턴한다.
 */
inline size_t __MIN(size_t x, size_t y, size_t z)
{
	return __MIN(__MIN(x, y), z);
}

/**
 *	최대값을 리턴한다.
 */
inline size_t __MAX(size_t x, size_t y)
{
	return x > y ? x : y;
}

/**
 *	최대값을 리턴한다.
 */
inline size_t __MAX(size_t x, size_t y, size_t z)
{
	return __MAX(__MAX(x, y), z);
}

__DCL_END_NAMESPACE

#endif			// __DCL_SIZE_T_H__
